const path = require('path');
require('dotenv').config({ path: path.resolve(__dirname, '../../.env') });
const { pool } = require('../config/db');

const migrateForum = async () => {
  let client;
  try {
    client = await pool.connect();
    await client.query('BEGIN');

    // Posts Table
    await client.query(`
      CREATE TABLE IF NOT EXISTS posts (
        id SERIAL PRIMARY KEY,
        title VARCHAR(255) NOT NULL,
        content TEXT NOT NULL,
        author_id INTEGER REFERENCES users(id) ON DELETE CASCADE,
        created_at TIMESTAMP WITH TIME ZONE DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP WITH TIME ZONE DEFAULT CURRENT_TIMESTAMP,
        likes_count INTEGER DEFAULT 0
      );
    `);

    // Comments Table
    await client.query(`
      CREATE TABLE IF NOT EXISTS comments (
        id SERIAL PRIMARY KEY,
        post_id INTEGER REFERENCES posts(id) ON DELETE CASCADE,
        author_id INTEGER REFERENCES users(id) ON DELETE CASCADE,
        content TEXT NOT NULL,
        created_at TIMESTAMP WITH TIME ZONE DEFAULT CURRENT_TIMESTAMP
      );
    `);

    // Post Likes Table (to track who liked what)
    await client.query(`
      CREATE TABLE IF NOT EXISTS post_likes (
        user_id INTEGER REFERENCES users(id) ON DELETE CASCADE,
        post_id INTEGER REFERENCES posts(id) ON DELETE CASCADE,
        PRIMARY KEY (user_id, post_id)
      );
    `);

    await client.query('COMMIT');
    console.log('Forum tables created successfully');
  } catch (e) {
    if (client) await client.query('ROLLBACK');
    console.error('Error creating forum tables', e);
    // Don't exit with error to allow bootstrap to continue, unless it's critical
    // process.exitCode = 1; 
  } finally {
    if (client) client.release();
    pool.end();
  }
};

migrateForum();
