const { pool } = require('../config/db');

const checkEvents = async () => {
  const client = await pool.connect();
  try {
    const res = await client.query('SELECT id, title, slug FROM events');
    console.log('Events in DB:', res.rows);
  } catch (e) {
    console.error(e);
  } finally {
    client.release();
    pool.end();
  }
};

checkEvents();
