const { pool } = require('../config/db');

const addSlugColumn = async () => {
  let client;
  try {
    client = await pool.connect();
    console.log('Adding slug column to events...');
    
    // Add column if not exists
    await client.query(`
      ALTER TABLE events 
      ADD COLUMN IF NOT EXISTS slug VARCHAR(255) UNIQUE;
    `);

    // Update existing event
    const eventTitle = 'Innovation Énergétique & Numérique';
    const slug = 'innov-energetique-numerique';
    
    // Check if slug already exists to avoid unique constraint violation
    const check = await client.query('SELECT 1 FROM events WHERE slug = $1', [slug]);
    
    if (check.rows.length === 0) {
      await client.query(`
          UPDATE events 
          SET slug = $1 
          WHERE title = $2
      `, [slug, eventTitle]);
      console.log('Slug column added and populated.');
    } else {
      console.log('Slug already exists, skipping update.');
    }

  } catch (e) {
    // Ignore unique constraint violations if they happen despite checks
    if (e.code === '23505') {
        console.log('Slug already exists (caught error), continuing...');
    } else {
        console.error('Error adding slug column:', e);
        // process.exitCode = 1; // Mark as failed for other errors
    }
  } finally {
    if (client) client.release();
    pool.end();
  }
};

addSlugColumn();
