const jwt = require('jsonwebtoken');
const db = require('../config/db');

const authenticateToken = (req, res, next) => {
  const token = req.cookies.token;

  if (!token) return res.sendStatus(401);

  jwt.verify(token, process.env.JWT_SECRET, (err, user) => {
    if (err) return res.sendStatus(403);
    req.user = user;
    next();
  });
};

const optionalAuthenticateToken = (req, res, next) => {
  const token = req.cookies.token;

  if (!token) {
    req.user = null;
    return next();
  }

  jwt.verify(token, process.env.JWT_SECRET, (err, user) => {
    if (err) {
      req.user = null;
    } else {
      req.user = user;
    }
    next();
  });
};

const authorizeRole = (roles) => {
  return async (req, res, next) => {
    if (!req.user) return res.sendStatus(401);

    try {
      // Fetch user role from DB to be sure (or rely on token payload if role is included)
      // Here we assume role_name is in the token for efficiency
      if (roles.includes(req.user.role)) {
        next();
      } else {
        res.status(403).json({ message: 'Access denied: Insufficient permissions' });
      }
    } catch (error) {
      res.status(500).json({ message: 'Server error during authorization' });
    }
  };
};

module.exports = { authenticateToken, optionalAuthenticateToken, authorizeRole };
